/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.game.prediction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_640;

public final class ElytraPredictionSystem {
    private static final int MAX_HISTORY_SIZE = 15;
    private static final double GRAVITY = -0.08;
    private static final double AIR_RESISTANCE_X = 0.99;
    private static final double AIR_RESISTANCE_Y = 0.98;
    private static final double AIR_RESISTANCE_Z = 0.99;
    private static final double PITCH_INFLUENCE = 0.06;
    private static final double DIRECTION_CORRECTION = 0.1;
    private static final long DATA_CLEANUP_INTERVAL = 30000L;
    private static final Map<UUID, List<MovementData>> movementHistory = new ConcurrentHashMap<UUID, List<MovementData>>();
    private static final Map<UUID, PlayerPredictionStats> playerStats = new ConcurrentHashMap<UUID, PlayerPredictionStats>();
    private static final Map<UUID, Integer> customPredictionTicks = new ConcurrentHashMap<UUID, Integer>();
    private static long lastCleanupTime = System.currentTimeMillis();

    public static class_243 predictPlayerPosition(class_1657 target) {
        if (target == null) {
            return class_243.field_1353;
        }
        ElytraPredictionSystem.updateEntityTracking(target);
        if (!ElytraPredictionSystem.isLeaving(target)) {
            return target.method_19538();
        }
        int predictionTicks = ElytraPredictionSystem.calculateOptimalPredictionTicks(target);
        return ElytraPredictionSystem.simulateElytraFlight(target, predictionTicks);
    }

    public static void updateEntityTracking(class_1657 entity) {
        if (entity != null) {
            UUID uuid = entity.method_5667();
            long currentTime = System.currentTimeMillis();
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                double distanceToClient = entity.method_5739((class_1297)client.field_1724);
                MovementData data = new MovementData(entity.method_19538(), entity.method_18798(), entity.method_36455(), entity.method_36454(), entity.method_6128(), currentTime, distanceToClient);
                List history = movementHistory.computeIfAbsent(uuid, k -> new ArrayList());
                history.add(data);
                if (history.size() > 15) {
                    history.remove(0);
                }
                ElytraPredictionSystem.updatePlayerStats(uuid, data);
                ElytraPredictionSystem.cleanupOldData(currentTime);
            }
        }
    }

    public static boolean isLeaving(class_1657 target) {
        if (!target.method_6128()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return false;
        }
        UUID uuid = target.method_5667();
        List<MovementData> history = movementHistory.get(uuid);
        if (history != null && history.size() >= 3) {
            boolean isDistanceIncreasing = ElytraPredictionSystem.isDistanceIncreasing(history);
            boolean isVelocityDirectedAway = ElytraPredictionSystem.isVelocityDirectedAway(target, (class_1657)client.field_1724);
            boolean hasSignificantSpeed = ElytraPredictionSystem.hasSignificantSpeed(target);
            int positiveChecks = 0;
            if (isDistanceIncreasing) {
                ++positiveChecks;
            }
            if (isVelocityDirectedAway) {
                ++positiveChecks;
            }
            if (hasSignificantSpeed) {
                ++positiveChecks;
            }
            return positiveChecks >= 2;
        }
        return false;
    }

    private static boolean isDistanceIncreasing(List<MovementData> history) {
        if (history.size() < 3) {
            return false;
        }
        int pointsToAnalyze = Math.min(5, history.size());
        List<MovementData> recentHistory = history.subList(history.size() - pointsToAnalyze, history.size());
        int increasingCount = 0;
        for (int i = 1; i < recentHistory.size(); ++i) {
            if (!(recentHistory.get((int)i).distanceToClient > recentHistory.get((int)(i - 1)).distanceToClient)) continue;
            ++increasingCount;
        }
        return increasingCount >= (recentHistory.size() - 1) / 2;
    }

    private static boolean isVelocityDirectedAway(class_1657 target, class_1657 client) {
        class_243 velocityDirection;
        class_243 targetPos = target.method_19538();
        class_243 clientPos = client.method_19538();
        class_243 targetVelocity = target.method_18798();
        class_243 directionToTarget = targetPos.method_1020(clientPos).method_1029();
        double dotProduct = directionToTarget.method_1026(velocityDirection = targetVelocity.method_1029());
        return dotProduct > 0.3;
    }

    private static boolean hasSignificantSpeed(class_1657 target) {
        double speed = target.method_18798().method_1033();
        return speed > 0.8;
    }

    private static class_243 simulateElytraFlight(class_1657 player, int ticksAhead) {
        class_243 position = player.method_19538();
        class_243 velocity = player.method_18798();
        float pitch = player.method_36455();
        float yaw = player.method_36454();
        boolean isFlying = player.method_6128();
        for (int tick = 0; tick < ticksAhead; ++tick) {
            if (isFlying) {
                position = ElytraPredictionSystem.simulateElytraTick(position, velocity, pitch, yaw);
                velocity = ElytraPredictionSystem.updateElytraVelocity(velocity, pitch, yaw);
                continue;
            }
            velocity = velocity.method_1031(0.0, -0.08, 0.0).method_1021(0.98);
            position = position.method_1019(velocity);
        }
        return position;
    }

    private static class_243 simulateElytraTick(class_243 position, class_243 velocity, float pitch, float yaw) {
        return position.method_1019(velocity);
    }

    private static class_243 updateElytraVelocity(class_243 velocity, float pitch, float yaw) {
        double yawAcceleration;
        double motionX = velocity.field_1352;
        double motionY = velocity.field_1351;
        double motionZ = velocity.field_1350;
        float pitchRad = (float)Math.toRadians(pitch);
        float yawRad = (float)Math.toRadians(yaw);
        class_243 lookDirection = new class_243(-Math.sin(yawRad) * Math.cos(pitchRad), -Math.sin(pitchRad), Math.cos(yawRad) * Math.cos(pitchRad));
        double horizontalVelocity = Math.sqrt(motionX * motionX + motionZ * motionZ);
        double lookHorizontal = Math.sqrt(lookDirection.field_1352 * lookDirection.field_1352 + lookDirection.field_1350 * lookDirection.field_1350);
        float cosPitch = (float)Math.cos(pitchRad);
        float cosPitchSq = cosPitch * cosPitch;
        if ((motionY += -0.08 + (double)cosPitchSq * 0.06) < 0.0 && lookHorizontal > 0.0) {
            yawAcceleration = motionY * -0.1 * (double)cosPitchSq;
            motionY += yawAcceleration;
            motionX += lookDirection.field_1352 * yawAcceleration / lookHorizontal;
            motionZ += lookDirection.field_1350 * yawAcceleration / lookHorizontal;
        }
        if (pitch < 0.0f && lookHorizontal > 0.0) {
            yawAcceleration = horizontalVelocity * -Math.sin(pitchRad) * 0.04;
            motionY += yawAcceleration * 3.2;
            motionX -= lookDirection.field_1352 * yawAcceleration / lookHorizontal;
            motionZ -= lookDirection.field_1350 * yawAcceleration / lookHorizontal;
        }
        if (lookHorizontal > 0.0) {
            motionX += (lookDirection.field_1352 / lookHorizontal * horizontalVelocity - motionX) * 0.1;
            motionZ += (lookDirection.field_1350 / lookHorizontal * horizontalVelocity - motionZ) * 0.1;
        }
        return new class_243(motionX *= 0.99, motionY *= 0.98, motionZ *= 0.99);
    }

    private static int calculateOptimalPredictionTicks(class_1657 target) {
        UUID uuid = target.method_5667();
        if (customPredictionTicks.containsKey(uuid)) {
            return customPredictionTicks.get(uuid);
        }
        int baseTicks = ElytraPredictionSystem.calculateNetworkDelay(target);
        List<MovementData> history = movementHistory.get(uuid);
        if (history != null && history.size() >= 3) {
            double velocityVariance = ElytraPredictionSystem.calculateVelocityVariance(history);
            double directionVariance = ElytraPredictionSystem.calculateDirectionVariance(history);
            if (target.method_6128()) {
                double speed = target.method_18798().method_1033();
                if (speed > 2.0) {
                    baseTicks += Math.min(4, (int)(speed * 1.2));
                }
                if (directionVariance > 30.0) {
                    baseTicks += 2;
                }
            }
            return Math.max(1, Math.min(15, baseTicks));
        }
        return baseTicks;
    }

    private static int calculateNetworkDelay(class_1657 player) {
        class_310 client = class_310.method_1551();
        int ping = 100;
        if (client.method_1562() != null) {
            try {
                class_640 playerListEntry = client.method_1562().method_2871(player.method_5667());
                if (playerListEntry != null) {
                    ping = playerListEntry.method_2959();
                }
            }
            catch (Exception playerListEntry) {
                // empty catch block
            }
        }
        int networkTicks = Math.max(1, ping / 50);
        int serverProcessingTicks = 2;
        return networkTicks + serverProcessingTicks;
    }

    private static double calculateVelocityVariance(List<MovementData> history) {
        if (history.size() < 2) {
            return 0.0;
        }
        double[] speeds = history.stream().mapToDouble(data -> data.velocity.method_1033()).toArray();
        double mean = Arrays.stream(speeds).average().orElse(0.0);
        double variance = Arrays.stream(speeds).map(speed -> Math.pow(speed - mean, 2.0)).average().orElse(0.0);
        return Math.sqrt(variance);
    }

    private static double calculateDirectionVariance(List<MovementData> history) {
        if (history.size() < 2) {
            return 0.0;
        }
        double totalVariance = 0.0;
        for (int i = 1; i < history.size(); ++i) {
            MovementData prev = history.get(i - 1);
            MovementData curr = history.get(i);
            double yawDiff = Math.abs(curr.yaw - prev.yaw);
            double pitchDiff = Math.abs(curr.pitch - prev.pitch);
            if (yawDiff > 180.0) {
                yawDiff = 360.0 - yawDiff;
            }
            totalVariance += Math.sqrt(yawDiff * yawDiff + pitchDiff * pitchDiff);
        }
        return totalVariance / (double)(history.size() - 1);
    }

    private static void updatePlayerStats(UUID uuid, MovementData data) {
        PlayerPredictionStats stats = playerStats.computeIfAbsent(uuid, k -> new PlayerPredictionStats());
        stats.update(data);
    }

    private static void cleanupOldData(long currentTime) {
        if (currentTime - lastCleanupTime >= 30000L) {
            lastCleanupTime = currentTime;
            movementHistory.entrySet().removeIf(entry -> {
                List history = (List)entry.getValue();
                history.removeIf(data -> currentTime - data.timestamp > 30000L);
                return history.isEmpty();
            });
            playerStats.entrySet().removeIf(entry -> currentTime - ((PlayerPredictionStats)entry.getValue()).lastUpdate > 30000L);
        }
    }

    @Generated
    private ElytraPredictionSystem() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class MovementData {
        public final class_243 position;
        public final class_243 velocity;
        public final float pitch;
        public final float yaw;
        public final boolean isFallFlying;
        public final long timestamp;
        public final double distanceToClient;

        public MovementData(class_243 position, class_243 velocity, float pitch, float yaw, boolean isFallFlying, long timestamp, double distanceToClient) {
            this.position = position;
            this.velocity = velocity;
            this.pitch = pitch;
            this.yaw = yaw;
            this.isFallFlying = isFallFlying;
            this.timestamp = timestamp;
            this.distanceToClient = distanceToClient;
        }
    }

    private static class PlayerPredictionStats {
        private double averageSpeed = 0.0;
        private int sampleCount = 0;
        private long lastUpdate = System.currentTimeMillis();

        private PlayerPredictionStats() {
        }

        public void update(MovementData data) {
            double speed = data.velocity.method_1033();
            this.averageSpeed = (this.averageSpeed * (double)this.sampleCount + speed) / (double)(this.sampleCount + 1);
            ++this.sampleCount;
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

